// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : input.cpp
// Date           : February 2008
//
// Description    : Refer to description in corresponding header.
//
// ///////////////////////////////////////////////////////////////////////////


#include "input.h"




Input::Input() :
  m_mouseX( 0 ),
  m_mouseY( 0 ),
  m_MouseButtons( 0 ),
  m_MousePrevButtons( 0 )
{
}



Input::~Input() 
{

}



void Input::Init( HWND hWnd ) 
{

  Log("Initializing static members of CInput...\n");

  // Hide Windows mouse pointer
  ShowCursor( false );

  // Clear input states
  ZeroMemory( m_keyCurrState, sizeof( m_keyCurrState ) );
  ZeroMemory( m_keyPrevState, sizeof( m_keyPrevState ) );
  ZeroMemory( &m_MouseButtons, sizeof( m_MouseButtons ) );
  ZeroMemory( &m_MousePrevButtons, sizeof( m_MousePrevButtons ) );
  m_anyKeyPressed = false;

}



void Input::Release() 
{

  Log("Releasing CInput...\n");

}



void Input::Update() 
{

  // Reset flag to indicate if *any* key is pressed
  m_anyKeyPressed = false;

  // Copy current state into previous state to easily determine if
  // state has changed since the last Update().
  for ( int i = 0; i < 256; i++ ) 
  {
    // Check if any key has just been pressed
    if ( ( !m_anyKeyPressed )
    &&   ( KeyPressed( i ) ) )
    {
      m_anyKeyPressed = true;
    }

    // Backup keyboard current state
    m_keyPrevState[i] = m_keyCurrState[i];
  }

  m_MousePrevButtons = m_MouseButtons;

}



bool Input::KeyDown( int key ) 
{

  return ( ( m_keyCurrState[key] & 0x80 ) != 0 );

}



bool Input::KeyPressed( int key ) 
{

  return ( ( ( m_keyPrevState[key] & 0x80 ) == 0 )
      &&   ( ( m_keyCurrState[key] & 0x80 ) != 0 ) );

}



bool Input::AnyKeyPressed() 
{

  return m_anyKeyPressed;

}



bool Input::MouseButtonDown( int button ) 
{


  return !!( m_MouseButtons & button );

}



bool Input::MouseButtonPressed( int button ) 
{
  return ( ( ( m_MousePrevButtons & button ) == 0 )
      &&   ( ( m_MouseButtons & button ) != 0 ) );
}



int Input::MouseX() 
{ 
  return m_mouseX; 
}



int Input::MouseY() 
{ 
  return m_mouseY; 
}



void Input::UpdateMouse( int Buttons, int X, int Y )
{

  m_MouseButtons = Buttons;

  m_mouseX = X;
  m_mouseY = Y;

}



void Input::KeyIsDown( int Key )
{

  m_keyCurrState[Key] = 0x80;

}



void Input::KeyIsUp( int Key )
{

  m_keyCurrState[Key] = 0;

}
